/* example of use of the Library Dynamic Mesa_gl.ldg in C
compiled with success for PureC and GCC 
Olivier LANDEMARRE le 18/6/2000 
It can work on all atari GEM system the video restriction is the restriction
for screen.ldg (to B&W -> 32bits TC) if direct memory acces is avaible (the slower is for
256 colors!)*/

/* WARNING LDG use the stack of the program witch call them and Mesa_gl need a good stack!!
near 32Ko don't forget to change your stack!!! (more if you use lists!!!) */


#include <stdio.h>
#ifdef __PUREC__
#include <tos.h> 
#include <vdi.h>
#else 
#include <osbind.h>
#include <vdibind.h>
#endif
#include <ldg.h>  /* To load LDGs */
#include "mesa_ldg.h"   /* Dfinitions pour OpenGL */
#include "scrnldg.h"   /* for screen.ldg     */

#ifndef __CDECL
#define __CDECL cdecl
#endif

/* base functions of screen.ldg */
long __CDECL (*screen_detect)(long vdihandle, char *answer);
long __CDECL (*screen_init)(long vdihandle, videoinf *display, char *type_ecran, sortievideo *more_infos, long flag);
static void __CDECL (*fix_palette)(sortievideo *more_infos, long mode, long vdihandle)=NULL;
void __CDECL (*screen_display)(long vdihandle, videoinf *display);
void __CDECL (*screen_display_texture)(long vdihandle, videoinf *display,long startx, long starty);

                  /* pour dclarer toutes les fonctions  utiliser 
                  dans Mesa */
#undef APIENTRY
#define APIENTRY __CDECL
                      /* toutes les fonctions ont un passage standard 
                      C de type _CDECL c'est la condition obligatoire 
                      */
                      /* fonctions standard OpenGL */
#include "initiny.c"
unsigned char *texture=NULL;
int app_id, vdihandle;
LDG *mesaldg,*screenldg;

void  APIENTRY onerror(long error)
{
	if(error==1L) form_alert("[1][Memory allocatio error in OpenGL!][End]");
	else form_alert("[1][Error in OpenGL!][End]");

	ldg_term(app_id,mesaldg);  /* clean close of MESA_GL.LDG */
  	ldg_term(app_id,screenldg);  /* clean close of SCREEN.LDG */
  
  	v_clsvwk(vdihandle);  
  	appl_exit();	 
  	exit(0);
}


int main()
{ int work_in[]= {1,1,1,1,1,1,1,1,1,1,2}, work_out[57],i;
	char retourneecc[50];  
 
  long mem1, mem2,mem3;
  videoinf mydisplay;
  sortievideo myinfos;
  char *image_buffer;   /* buffer de l'image gnre */
  long width=300, height=300;  /* taille de l'image  gnrer */
  
  app_id = appl_init ();            /* AES init need for LDG*/
  /*                   ----------------------------------------                  */
  
                                    /* Load of screen.ldg */
  if((screenldg = ldg_exec ( app_id, "screen.ldg")) == NULL)  /* Load of screen.ldg */
  { 
  	if((screenldg = ldg_exec ( app_id, "screen.ldg")) == NULL) /* Retry */
  	{
  		
  		form_alert ( 1, "[1][Can't load |SCREEN.LDG!][OK]");
    	appl_exit();
    	return(0);
    }
  }
  /*                       ---------------------------------                  */
  			       /* link of screen.ldg functions */
  screen_detect=ldg_find("screen_detect", screenldg);
  screen_init=ldg_find("screen_init", screenldg);
  fix_palette=ldg_find("fix_palette", screenldg);
  screen_display=ldg_find("screen_display", screenldg);
  screen_display_texture=ldg_find("screen_display_texture", screenldg);

  /*                       ---------------------------------                  */
  
  (void)v_opnvwk(work_in,&vdihandle,work_out); /* VDI workstation needed */

  { char *video,*oldscreen;  int mwork_out2[57],nb_plans;
  	while(!wind_update(BEG_UPDATE));   /* attente qu'il n'y ai plus de dessin  l'cran!! */
    vq_extnd((int)vdihandle,1,mwork_out2);
		nb_plans=mwork_out2[4]; 
  	video=(char *)ldg_Malloc((long)((work_out[0]+33))*5L*(long)(nb_plans)/8L);    /* 5 lignes suffisent */
  	oldscreen=(char *)Logbase();
  	if(video!=NULL) Setscreen(video,-1L,-1);   /* nouveau logbase pour screen_detect() */
  /*                       ---------------------------------                  */

                        /* Use of screen.ldg */
  	if(screen_detect((long)vdihandle,retourneecc)<0)    /* detection of memory screen */
  	{
  		Setscreen(oldscreen,-1L,-1);  /* on remet l'ancien Logbase */
  		ldg_Free(video);
  		wind_update(END_UPDATE);   /* on relaisse l'cran libre */
  		ldg_term(app_id,mesaldg);  /* clean close of MESA_GL.LDG */
  		ldg_term(app_id,screenldg);  /* clean close of SCREEN.LDG */
  		form_alert ( 1, "[1][Detection error in SCREEN!][OK]");
  	  appl_exit();
  	  return(0);
  	}
  	
  	Setscreen(oldscreen,-1L,-1);    /* on remet l'ancien Logbase */
  	ldg_Free(video); 
  	wind_update(END_UPDATE);   /* on relaisse l'cran libre */
  }

							/* emulators like Stemulator where Palette don't work well!!! use gray can be recognize by SP ex 8CSP or 8ESP */
  if((retourneecc[1]=='C')&&(retourneecc[2]=='S')&&(retourneecc[3]=='P'))retourneecc[1]='G';
  if((retourneecc[2]=='C')&&(retourneecc[3]=='S')&&(retourneecc[4]=='P'))retourneecc[1]='G';


  if(screen_init((long)vdihandle, &mydisplay,retourneecc,&myinfos,0L)<=0)  /* is it supported ??? */
  {            /* No !!! */
  	ldg_term(app_id,screenldg);  /* clean close of SCREEN.LDG */
  	form_alert ( 1, "[1][Your display isn't supported by SCREEN|, sorry (must be >=256 colors)][OK]");
    appl_exit();
    return(0);
  }
  		
  { int nb_plans;
  	sscanf(retourneecc,"%d",&nb_plans);     /* take number of color planes */
  	
  	if((nb_plans<=8)&&(nb_plans>1)) 
  	{
  		fix_palette(&myinfos, 1L, (long) vdihandle); /* fix palette */
  	}
  }
  			/* SRC image description  */
  mydisplay.largeur_RGB=(unsigned WORD)width;
  mydisplay.hauteur_RGB=(unsigned WORD)height;
       	 
  			/* Position of draw on screen */
  mydisplay.position_X=20; 
  mydisplay.position_Y=20;
       	 	/* position in SRC image to draw*/
  mydisplay.X_voulu=0;
  mydisplay.Y_voulu=0;
       	 	/* size to draw */
  mydisplay.largeur_voulue=(unsigned WORD)width;
  mydisplay.hauteur_voulue=(unsigned WORD)height;
       	 
  /*                       ---------------------------------                  */

  	/* load of mesa_gl.ldg */
  if( (mesaldg = ldg_exec ( app_id, "tiny_gl.ldg")) == NULL)  /* Load of mesa_gl.ldg*/
  { /* chec */
  	/* vous pouvez relancer ventuellement ldg_exec() des fois que 
  	le systme soit lambin !!! (Mint + Multitos) ca passe souvent 
  	mesa est trs grosse */
  	if( (mesaldg = ldg_exec ( app_id, "tiny_gl.ldg")) == NULL)   /* retry */ 
  	{
	  	ldg_term(app_id,screenldg);  /* clean close of MESA_GL.LDG */
 	  	form_alert ( 1, "[1][Can't load |TINY_GL.LDG!][OK]");
 	  	appl_exit();
 	  	return(0);
    }
  }
  init_tiny(mesaldg);   /* dynamic link of functions of mesa */
	if(exception_error!=NULL) exception_error(onerror); /* function for exception error */
  /*                       ---------------------------------                  */
  
  /* Use of Mesa - OpenGL */
  
  /* initialisation (specific to Mesa_gl.ldg ) */
  texture=ldg_Malloc(256L*256L*3L);
  if(texture)
  { int i,j;  unsigned char *ptex=texture;
  	for(j=0;j<255;j++)
  	{
  		for(i=0;i<255;i++)
  		{
  			*ptex++=i;
  			*ptex++=0;
  			*ptex++=255-j;
  		}
  	}
  	
  }
  else printf("ERREUR Alloc\015\012");
  mem1=Malloc(-1L);
  image_buffer = OSMesaCreateLDG(VDI_RGB, (long)GL_UNSIGNED_BYTE, width, height );
  	/* create the context, this function return the address of picture
  	First parameter : Type of picture to do (see gl.h) we choice VDI_RGB witch is
  	the natural format for screen.ldg (24R8V8B8 format)
  	cration du contexte la fonction retourne le pointeur sur 
  	2eme parameter : Always  GL_UNSIGNED_BYTE
  	3eme et 4eme parameter width and height of picture to calculate
  	The maximal size can know with use of functions max_width() and max_height()
  	
  	*/
  	
  /*                       ---------------------------------                  */ 	                        
  if(image_buffer)  /* initialisation OK */
  { int status; long t1,t2;
  float x=0.5,y=0.2,z=0.5; 
  	
  	
    mydisplay.add_RGB=(long)image_buffer;    /* for screen to know where is the picture to draw */
    
    /* OpenGL only */
                             /* use of OpenGL see documentation on OpenGl*/
    glMatrixMode((long)GL_PROJECTION);
    glLoadIdentity();  /* Identity matrix */
    glOrtho(-1.0,       1.0,   -1.0,    1.0,  -1.0,    1.0);  /* the space of calculation*/
         /*
                Y | 
                  |
                  |-------X
                 /
               Z/ 
                      */
    glMatrixMode((long)GL_MODELVIEW);     /* projection mode */
    glClearColor(0.0,0.0,0.1,0.0);  /* clear color RGBA (dark blue) */
    glClear( (long)(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) );   /* to clear */
    glEnable(GL_DEPTH_TEST);    /* test of position of course */
 /*   glEnable(GL_TEXTURE_2D); 
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
    glTexImage2D(GL_TEXTURE_2D,0,3,256,256,0,GL_RGB,GL_UNSIGNED_BYTE,texture);
    glTexEnvi(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_DECAL);*/
    t1=Gettime();
    glPolygonMode(GL_BACK,GL_LINE); 
    for(i=0;i<100;i++)    /* for rotation */
    
		{
		/* vq_key_s(vdihandle,&status);*/  /* get keyboard */
		/* if((status&0x7)!=0) i=1020; */ /* stop if ctrl or shift */
   	 glRotatef(8., .5, 1.0, 0.3); /* rotation of the objects after */
   	 glClear( (long)(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) );   /* clear */
     glBegin(GL_TRIANGLES);  /* to use triangle 3point for each */
		                      
	   glColor3f(0.0, 0.0, 1.0);   /* each point can have there own color (blue)*/
	   glVertex3f(-0.5, 0.0, 0.0);  /* first point */
		 glColor3f(1.0, 1.0, 1.0);   /* white */
		 glVertex3f(0.0, 0.5, 0.2);  /* second point */ 
		 glColor3f(1.0, 0.0, 0.0);   /* red */
		 glVertex3f(0.5, 0.0, 0.0);  /* third point */
		
		 glColor3f(0.0, 1.0, 0.0);     /* a triangle all green */	 
		 glVertex3f(-x, y, -z);  /* first point */
		 glVertex3f(x, y, -z);   /* second point */		 	
		 glVertex3f(0.0, -0.1, z);   /* third point */
		 
     glEnd();   /* end for triangles */
     glBegin(GL_LINES);
     glVertex3f(0.0, 0.0, 0.0); 
     glVertex3f(0.0, 0.5, 0.0);
     glEnd();
        /* end of call of OpenGL */
  /*  swapbuffer(NULL); */
    screen_display(vdihandle, &mydisplay); /* display picture directly on screen */
    
    }
    t2=Gettime();
    mem3=Malloc(-1L);
    OSMesaDestroyLDG();      				/* destroy context */
  /*  Save_TGA("image.tga", image_buffer, width, height);  / * save picture */
    Mfree( image_buffer );   				/* Don't forget to free the picture */
    form_dial(3,20,20,(int)width,(int)height,20,20,(int)width,(int)height);  /* redraw the desktop */
    mem2=Malloc(-1L);
  }
  else form_alert ( 1, "[1][Memory allocation failed!][OK]");
  ldg_term(app_id,mesaldg);  /* clean close of MESA_GL.LDG */
  ldg_term(app_id,screenldg);  /* clean close of SCREEN.LDG */
  
  v_clsvwk(vdihandle);  
  appl_exit();
  ldg_Free(texture);
  return(1);
}